within PowerGrids.Examples;

package Overview
  extends Modelica.Icons.Information;
   annotation(
    preferredView = "info",
    Documentation(info = "<html><head></head><body><p>This package contains a number of system examples to illustrate the functionality of the PowerGrids library.</p>
<p>The <a href=\"modelica://PowerGrids.Examples.ENTSOE.Info\">ENTSOE</a> package contains test cases using a simple system model that is described in a publicly available ENTSO-E report, which compares the results obtained on a small and simple test case with different power system simulation tools. The differences observed advocate for the use of open-source models and software for power system modelling ad simulation.</p>
<p>The <a href=\"modelica://PowerGrids.Examples.Tutorial\">Tutorial</a> package contains the companion models of the <a href=\"modelica://PowerGrids.UsersGuide.Tutorial\">PowerGrids Tutorial</a>; you are referred to that for their documentation.</p>
<p>Finally, the contents of the <a href=\"modelica://PowerGrids.Examples.IEEE14bus.Info\">IEEE14bus</a>&nbsp;package demonstrate the use of the PowerGrids library to simulate the well-known IEEE 14-bus power system model.</p>
</body></html>"));
end Overview;
